/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class InstancePreferences
extends EclipsePreferences {
    private String qualifier;
    private int segmentCount;
    private IEclipsePreferences loadLevel;
    private IPath location;
    private static Set loadedNodes = new HashSet();
    private static boolean initialized = false;
    private static IPath baseLocation = InternalPlatform.getDefault().getMetaArea().getStateLocation("org.eclipse.core.runtime");

    public InstancePreferences() {
        this(null, null);
    }

    private InstancePreferences(IEclipsePreferences parent, String name) {
        super(parent, name);
        this.initializeChildren();
        String path = this.absolutePath();
        this.segmentCount = EclipsePreferences.getSegmentCount(path);
        if (this.segmentCount < 2) {
            return;
        }
        this.qualifier = EclipsePreferences.getSegment(path, 1);
        if (this.qualifier == null) {
            return;
        }
        this.location = this.computeLocation(baseLocation, this.qualifier);
    }

    protected boolean isAlreadyLoaded(IEclipsePreferences node) {
        return loadedNodes.contains(node.name());
    }

    protected void loaded() {
        loadedNodes.add(this.name());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadLegacy() {
        block16: {
            path = new Path(this.absolutePath());
            if (path.segmentCount() != 2) {
                return;
            }
            bundleName = path.segment(1);
            prefFile = InternalPlatform.getDefault().getMetaArea().getPreferenceLocation(bundleName, false).toFile();
            if (!prefFile.exists()) {
                if (InternalPlatform.DEBUG_PREFERENCES == false) return;
                Policy.debug("Legacy plug-in preference file not found: " + prefFile);
                return;
            }
            if (InternalPlatform.DEBUG_PREFERENCES) {
                Policy.debug("Loading legacy preferences from " + prefFile);
            }
            input = null;
            values = new Properties();
            try {
                try {
                    input = new BufferedInputStream(new FileInputStream(prefFile));
                    values.load(input);
                }
                catch (IOException v0) {
                    if (InternalPlatform.DEBUG_PREFERENCES) {
                        Policy.debug("IOException encountered loading legacy preference file " + prefFile);
                    }
                    var6_6 = null;
                    if (input == null) return;
                    try {
                        input.close();
                        return;
                    }
                    catch (IOException e) {
                        if (InternalPlatform.DEBUG_PREFERENCES == false) return;
                        Policy.debug("IOException encountered closing legacy preference file " + prefFile);
                        e.printStackTrace();
                    }
                    return;
                }
            }
            catch (Throwable var7_12) {
                var6_7 = null;
                if (input == null) throw var7_12;
                ** try [egrp 2[TRYBLOCK] [3 : 190->198)] { 
lbl38:
                // 1 sources

                input.close();
                throw var7_12;
lbl40:
                // 1 sources

                catch (IOException e) {
                    if (InternalPlatform.DEBUG_PREFERENCES == false) throw var7_12;
                    Policy.debug("IOException encountered closing legacy preference file " + prefFile);
                    e.printStackTrace();
                }
                throw var7_12;
            }
            {
                var6_8 = null;
                if (input == null) break block16;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 190->198)] { 
lbl48:
            // 1 sources

            input.close();
            break block16;
lbl50:
            // 1 sources

            catch (IOException e) {
                if (!InternalPlatform.DEBUG_PREFERENCES) break block16;
                Policy.debug("IOException encountered closing legacy preference file " + prefFile);
                e.printStackTrace();
            }
        }
        i = values.keySet().iterator();
        while (true) {
            if (!i.hasNext()) {
                if (prefFile.delete() != false) return;
                if (InternalPlatform.DEBUG_PREFERENCES == false) return;
                Policy.debug("Unable to delete legacy preferences file: " + prefFile);
                return;
            }
            key = (String)i.next();
            value = values.getProperty(key);
            if (value == null) continue;
            if (InternalPlatform.DEBUG_PREFERENCES) {
                Policy.debug("Loaded legacy preference: " + key + " -> " + value);
            }
            if (value.equals(oldValue = this.internalPut(key, value))) continue;
            this.makeDirty();
        }
    }

    protected IPath getLocation() {
        return this.location;
    }

    protected IEclipsePreferences getLoadLevel() {
        if (this.loadLevel == null) {
            if (this.qualifier == null) {
                return null;
            }
            IEclipsePreferences node = this;
            int i = 2;
            while (i < this.segmentCount) {
                node = (IEclipsePreferences)node.parent();
                ++i;
            }
            this.loadLevel = node;
        }
        return this.loadLevel;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void initializeChildren() {
        if (initialized) return;
        if (this.parent == null) {
            return;
        }
        try {
            InstancePreferences instancePreferences = this;
            synchronized (instancePreferences) {
                String[] names = this.computeChildren(baseLocation);
                int i = 0;
                while (true) {
                    block8: {
                        if (i < names.length) break block8;
                        break;
                    }
                    this.addChild(names[i], null);
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            initialized = true;
            throw throwable;
        }
        {
            Object var4_6 = null;
            initialized = true;
            return;
        }
    }

    protected EclipsePreferences internalCreate(IEclipsePreferences nodeParent, String nodeName, Plugin context) {
        return new InstancePreferences(nodeParent, nodeName);
    }
}

