/*
 * Decompiled with CFR 0.152.
 */
package ProcesadorDocumentos.XMLHelpers;

import ProcesadorDocumentos.XMLHelpers.AttrContainer;
import ProcesadorDocumentos.XMLHelpers.ContainerItem;
import ProcesadorDocumentos.XMLHelpers.documentWrapper;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXDocParser
extends DefaultHandler {
    private static int INITIAL = 0;
    private static int WAIT_FOR_ELEMENT = 1;
    private static int DECIDE_ELEMENT_TYPE = 2;
    private static int WAIT_FOR_CONTAINER_ITEM = 3;
    private Stack elements = new Stack();
    private Stack docItems = new Stack();
    private Stack docContainers = new Stack();
    private StringBuffer value;
    private documentWrapper doc;
    private int State;

    public SAXDocParser(documentWrapper doc) {
        this.doc = doc;
        this.State = INITIAL;
        this.docItems.push(doc);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String name = localName.equals("") ? qName : localName;
        this.elements.push(name);
        this.value = new StringBuffer("");
        if (this.elements.size() == 1) {
            if (!name.equals("Documento")) {
                throw new SAXException("Elemento raiz debe llamarse 'Documento'");
            }
            this.doc.DocType = atts.getValue("tipo");
            this.doc.Version = atts.getValue("version");
        }
        switch (this.State) {
            case 0: {
                this.State = WAIT_FOR_ELEMENT;
                break;
            }
            case 1: {
                this.State = DECIDE_ELEMENT_TYPE;
                break;
            }
            case 2: {
                String cntName = (String)this.elements.elementAt(this.elements.size() - 2);
                this.docContainers.push(((ContainerItem)this.docItems.peek()).addContainer(cntName, name));
                this.docItems.push(((AttrContainer)this.docContainers.peek()).addItem());
                this.State = WAIT_FOR_ELEMENT;
                break;
            }
            case 3: {
                this.docItems.push(((AttrContainer)this.docContainers.peek()).addItem());
                this.State = WAIT_FOR_ELEMENT;
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        String name;
        String string = name = localName.equals("") ? qName : localName;
        if (name.equals("Documento")) {
            return;
        }
        String popped = (String)this.elements.pop();
        switch (this.State) {
            case 1: {
                this.docItems.pop();
                this.State = WAIT_FOR_CONTAINER_ITEM;
                break;
            }
            case 2: {
                ((ContainerItem)this.docItems.peek()).attributes.setProperty(name, this.value.toString());
                this.State = WAIT_FOR_ELEMENT;
                break;
            }
            case 3: {
                this.docContainers.pop();
                this.State = WAIT_FOR_ELEMENT;
            }
        }
    }

    public void characters(char[] buf, int offset, int len) {
        String s = new String(buf, offset, len);
        this.value.append(s);
    }
}

