/*
 * Decompiled with CFR 0.152.
 */
package sms.validador;

import ProcesadorDocumentos.XMLHelpers.AttrContainer;
import ProcesadorDocumentos.XMLHelpers.ContainerItem;
import ProcesadorDocumentos.XMLHelpers.documentWrapper;
import courier.anulacion.schema.Documento;
import courier.anulacion.schema.DocumentoType;
import courier.anulacion.schema.ObjectFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Validator;
import sms.soap.Start;
import sms.util.Util;

public class CourierANUv10 {
    private String file;
    private String doc;
    private boolean valid = false;

    public CourierANUv10(String file, String doc) {
        this.file = file;
        this.doc = doc;
        this.init();
    }

    private void init() {
        try {
            ObjectFactory objFactory = new ObjectFactory();
            Documento documento = objFactory.createDocumento();
            documentWrapper dw = new documentWrapper(new File(this.file));
            documento.setTipo(dw.getDocType());
            if (dw.getVersion().equals("1.0")) {
                documento.setVersion(dw.getVersion().trim());
            }
            if (dw.existAttribute("tipo-accion") && !dw.getAttribute("tipo-accion").equals("")) {
                documento.setTipoAccion(dw.getAttribute("tipo-accion").trim());
            }
            if (dw.existAttribute("id-documento-servidor") && dw.getAttribute("id-documento-servidor").equals("")) {
                documento.setIdDocumentoServidor(dw.getAttribute("id-documento-servidor").trim());
            }
            if (dw.existAttribute("numero-referencia") && !dw.getAttribute("numero-referencia").equals("")) {
                documento.setNumeroReferencia(dw.getAttribute("numero-referencia").trim());
            }
            this.cargaFechas(documento, dw);
            this.cargaParticipantes(documento, dw);
            this.cargaObservaciones(documento, dw);
            JAXBContext jc = JAXBContext.newInstance("courier.anulacion.schema");
            Validator v = jc.createValidator();
            this.valid = v.validateRoot(documento);
            if (this.valid) {
                Marshaller m = jc.createMarshaller();
                m.setProperty("jaxb.encoding", "ISO-8859-1");
                m.setProperty("jaxb.formatted.output", Boolean.TRUE);
                if (!new File(String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "mensajes").exists()) {
                    new File(String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "mensajes").mkdirs();
                }
                String xml = String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "mensajes" + Util.getSEPARADOR() + this.doc;
                m.marshal((Object)documento, new FileOutputStream(xml));
            }
        }
        catch (Exception e) {
            if (!this.valid) {
                Start.pe("\t=> [" + this.doc + "]: Documento Courier de Anulacion con Estructura Invalida.-");
                if (e.toString().indexOf(".Abort") != -1) {
                    String msgError = e.toString().substring(e.toString().indexOf(".Abort") + 19, e.toString().length() - 1);
                    Start.pe("\t+ " + msgError);
                } else {
                    Start.pe("\t+ " + e.toString());
                }
                Start.pe("\t=> Moviendo documento [" + this.doc + "] a [SMS_Home\\xml\\invalidos].-\n\n");
            }
            Start.pe("\t=> [" + this.doc + "]: Error manipulando archivo. Posiblemente no tiene permisos necesarios.-\n\n");
            this.valid = false;
        }
    }

    private void cargaFechas(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("Fechas")) {
                DocumentoType.FechasType fechas = objFactory.createDocumentoTypeFechasType();
                AttrContainer atc = dw.getContainer("Fechas");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.FechasType.FechaType fecha = objFactory.createDocumentoTypeFechasTypeFechaType();
                    if (prop.containsKey("nombre") && !prop.get("nombre").equals("")) {
                        fecha.setNombre(String.valueOf(prop.get("nombre")).trim());
                    }
                    if (prop.containsKey("valor") && !prop.get("valor").equals("")) {
                        fecha.setValor(String.valueOf(prop.get("valor")).trim());
                    }
                    fechas.setFecha(fecha);
                }
                documento.setFechas(fechas);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cargaParticipantes(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("Participaciones")) {
                DocumentoType.ParticipacionesType PartTp = objFactory.createDocumentoTypeParticipacionesType();
                AttrContainer atc = dw.getContainer("Participaciones");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.ParticipacionesType.ParticipacionType partTp = objFactory.createDocumentoTypeParticipacionesTypeParticipacionType();
                    if (prop.containsKey("nombre") && !prop.get("nombre").equals("")) {
                        partTp.setNombre(String.valueOf(prop.get("nombre")).trim());
                    }
                    if (prop.containsKey("tipo-id") && !prop.get("tipo-id").equals("")) {
                        partTp.setTipoId(String.valueOf(prop.get("tipo-id")).trim());
                    }
                    if (prop.containsKey("valor-id") && !prop.get("valor-id").equals("")) {
                        partTp.setValorId(String.valueOf(prop.get("valor-id")).trim());
                    }
                    if (prop.containsKey("nacion-id") && !prop.get("nacion-id").equals("")) {
                        partTp.setNacionId(String.valueOf(prop.get("nacion-id")).trim());
                    }
                    if (prop.containsKey("nombres") && !prop.get("nombres").equals("")) {
                        partTp.setNombres(String.valueOf(prop.get("nombres")).trim());
                    }
                    PartTp.setParticipacion(partTp);
                }
                documento.setParticipaciones(PartTp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cargaObservaciones(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("Observaciones")) {
                DocumentoType.ObservacionesType ObTp = objFactory.createDocumentoTypeObservacionesType();
                AttrContainer atc = dw.getContainer("Observaciones");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.ObservacionesType.ObservacionType obTp = objFactory.createDocumentoTypeObservacionesTypeObservacionType();
                    if (prop.containsKey("fecha") && !prop.get("fecha").equals("")) {
                        obTp.setFecha(String.valueOf(prop.get("fecha")).trim());
                    }
                    if (prop.containsKey("login-usuario") && !prop.get("login-usuario").equals("")) {
                        obTp.setLoginUsuario(String.valueOf(prop.get("login-usuario")).trim());
                    }
                    if (prop.containsKey("nombre") && !prop.get("nombre").equals("")) {
                        obTp.setNombre(String.valueOf(prop.get("nombre")).trim());
                    }
                    if (prop.containsKey("contenido") && !prop.get("contenido").equals("")) {
                        obTp.setContenido(String.valueOf(prop.get("contenido")).trim());
                    }
                    ObTp.getObservacion().add(obTp);
                }
                documento.setObservaciones(ObTp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isValid() {
        return this.valid;
    }
}

