/*
 * Decompiled with CFR 0.152.
 */
package sms.validador;

import ProcesadorDocumentos.XMLHelpers.AttrContainer;
import ProcesadorDocumentos.XMLHelpers.ContainerItem;
import ProcesadorDocumentos.XMLHelpers.documentWrapper;
import gr.schema.Documento;
import gr.schema.DocumentoType;
import gr.schema.ObjectFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.Validator;
import sms.soap.Start;
import sms.util.Util;

public class GRv10 {
    private String file;
    private String doc;
    private boolean valid = false;

    public GRv10(String file, String doc) {
        this.file = file;
        this.doc = doc;
        this.init();
    }

    private void init() {
        try {
            ObjectFactory objFactory = new ObjectFactory();
            Documento documento = objFactory.createDocumento();
            documentWrapper dw = new documentWrapper(new File(this.file));
            this.cargaRoot(documento, dw);
            this.cargaItems(documento, dw);
            JAXBContext jc = JAXBContext.newInstance("gr.schema");
            Validator v = jc.createValidator();
            this.valid = v.validateRoot(documento);
            if (this.valid) {
                Marshaller m = jc.createMarshaller();
                m.setProperty("jaxb.encoding", "ISO-8859-1");
                m.setProperty("jaxb.formatted.output", Boolean.TRUE);
                if (!new File(String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "mensajes").exists()) {
                    new File(String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "mensajes").mkdirs();
                }
                String xml = String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "mensajes" + Util.getSEPARADOR() + this.doc;
                m.marshal((Object)documento, new FileOutputStream(xml));
            }
        }
        catch (Exception e) {
            if (!this.valid) {
                Start.pe("\t=> [" + this.doc + "]: GR con Estructura Invalida.-");
                if (e.toString().indexOf(".Abort") != -1) {
                    String msgError = e.toString().substring(e.toString().indexOf(".Abort") + 19, e.toString().length() - 1);
                    Start.pe("\t+ " + msgError);
                } else {
                    Start.pe("\t+ " + e.toString());
                }
                Start.pe("\t=> Moviendo documento [" + this.doc + "] a [SMS_Home\\xml\\invalidos].-\n\n");
            }
            Start.pe("\t=> [" + this.doc + "]: Error manipulando archivo. Posiblemente no tiene permisos necesarios.-\n\n");
            this.valid = false;
        }
    }

    private void cargaRoot(Documento documento, documentWrapper dw) {
        try {
            if (dw.getDocType().equals("GR")) {
                documento.setTipo(dw.getDocType());
            }
            if (dw.getVersion().equals("1.0")) {
                documento.setVersion(dw.getVersion());
            }
            if (dw.existAttribute("tipo-accion") && !dw.getAttribute("tipo-accion").equals("")) {
                documento.setTipoAccion(dw.getAttribute("tipo-accion").trim());
            } else {
                documento.setTipoAccion("I");
            }
            if (dw.existAttribute("nro-manifiesto") && !dw.getAttribute("nro-manifiesto").equals("")) {
                documento.setNroManifiesto(dw.getAttribute("nro-manifiesto").trim());
            }
            if (dw.existAttribute("fecha-recepcion") && !dw.getAttribute("fecha-recepcion").equals("")) {
                documento.setFechaRecepcion(dw.getAttribute("fecha-recepcion").trim());
            }
            if (dw.existAttribute("viaje_vuelo") && !dw.getAttribute("viaje_vuelo").equals("")) {
                documento.setViajeVuelo(dw.getAttribute("viaje_vuelo").trim());
            }
            if (dw.existAttribute("folio") && !dw.getAttribute("folio").equals("")) {
                documento.setFolio(dw.getAttribute("folio").trim());
            }
            if (dw.existAttribute("conocimiento-embarque") && !dw.getAttribute("conocimiento-embarque").equals("")) {
                documento.setConocimientoEmbarque(dw.getAttribute("conocimiento-embarque").trim());
            }
            if (dw.existAttribute("consignatario") && !dw.getAttribute("consignatario").equals("")) {
                documento.setConsignatario(dw.getAttribute("consignatario").trim());
            }
            documento.setEmisor(this.getRutEmisor());
            if (dw.existAttribute("pto-origen") && !dw.getAttribute("pto-origen").equals("")) {
                documento.setPtoOrigen(dw.getAttribute("pto-origen").trim());
            }
            if (dw.existAttribute("bultos-documentados") && !dw.getAttribute("bultos-documentados").equals("")) {
                documento.setBultosDocumentados(dw.getAttribute("bultos-documentados").trim());
            }
            if (dw.existAttribute("peso-documentado") && !dw.getAttribute("peso-documentado").equals("")) {
                documento.setPesoDocumentado(dw.getAttribute("peso-documentado").trim());
            }
            if (dw.existAttribute("bultos-verificados") && !dw.getAttribute("bultos-verificados").equals("")) {
                documento.setBultosVerificados(dw.getAttribute("bultos-verificados").trim());
            }
            if (dw.existAttribute("peso-verificado") && !dw.getAttribute("peso-verificado").equals("")) {
                documento.setPesoVerificado(dw.getAttribute("peso-verificado").trim());
            }
            if (dw.existAttribute("estado-bulto") && !dw.getAttribute("estado-bulto").equals("")) {
                documento.setEstadoBulto(dw.getAttribute("estado-bulto").trim());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cargaItems(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("Items")) {
                DocumentoType.ItemsType items = objFactory.createDocumentoTypeItemsType();
                AttrContainer atc = dw.getContainer("Items");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.ItemsType.ItemType item = objFactory.createDocumentoTypeItemsTypeItemType();
                    if (prop.containsKey("clase-bulto") && !prop.get("clase-bulto").equals("")) {
                        item.setClaseBulto(String.valueOf(prop.get("clase-bulto")).trim());
                    }
                    if (prop.containsKey("cantidad") && !prop.get("cantidad").equals("")) {
                        item.setCantidad(String.valueOf(prop.get("cantidad")).trim());
                    }
                    if (prop.containsKey("bodega") && !prop.get("bodega").equals("")) {
                        item.setBodega(String.valueOf(prop.get("bodega")).trim());
                    }
                    if (prop.containsKey("ubicacion") && !prop.get("ubicacion").equals("")) {
                        item.setUbicacion(String.valueOf(prop.get("ubicacion")).trim());
                    }
                    if (prop.containsKey("peso") && !prop.get("peso").equals("")) {
                        item.setPeso(String.valueOf(prop.get("peso")).trim());
                    }
                    if (prop.containsKey("observacion") && !prop.get("observacion").equals("")) {
                        item.setObservacion(String.valueOf(prop.get("observacion")).trim());
                    }
                    items.getItem().add(item);
                }
                documento.setItems(items);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getRutEmisor() {
        try {
            emisor.schema.Documento documento;
            JAXBContext jc = JAXBContext.newInstance("emisor.schema");
            Unmarshaller u = jc.createUnmarshaller();
            if (!new File(String.valueOf(Util.getPATH()) + "/conf/emisor.xml").exists()) {
                new File(String.valueOf(Util.getPATH()) + "/conf/emisor.xml");
            }
            if ((documento = (emisor.schema.Documento)u.unmarshal(new FileInputStream(String.valueOf(Util.getPATH()) + "/conf/emisor.xml"))).getValorId() != null && !documento.getValorId().trim().equals("")) {
                return documento.getValorId().trim();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "NO_DATA";
    }

    public boolean isValid() {
        return this.valid;
    }
}

