/*
 * Decompiled with CFR 0.152.
 */
package sms.validador;

import ProcesadorDocumentos.XMLHelpers.AttrContainer;
import ProcesadorDocumentos.XMLHelpers.ContainerItem;
import ProcesadorDocumentos.XMLHelpers.documentWrapper;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Validator;
import sms.soap.Start;
import sms.util.Util;
import tif.schema.Documento;
import tif.schema.DocumentoType;
import tif.schema.ObjectFactory;

public class TIFv10 {
    private String file;
    private String doc;
    private boolean valid = false;

    public TIFv10(String file, String doc) {
        this.file = file;
        this.doc = doc;
        this.init();
    }

    private void init() {
        try {
            ObjectFactory objFactory = new ObjectFactory();
            Documento docOut = objFactory.createDocumento();
            documentWrapper docIn = new documentWrapper(new File(this.file));
            this.setRootTIF(docIn, docOut);
            this.setParticipantesTIF(docIn, docOut);
            this.setRootCPF(docIn, docOut);
            JAXBContext jc = JAXBContext.newInstance("tif.schema");
            Validator v = jc.createValidator();
            this.valid = v.validateRoot(docOut);
            if (this.valid) {
                Marshaller m = jc.createMarshaller();
                m.setProperty("jaxb.encoding", "ISO-8859-1");
                m.setProperty("jaxb.formatted.output", Boolean.TRUE);
                if (!new File(String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "mensajes").exists()) {
                    new File(String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "mensajes").mkdirs();
                }
                String xml = String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "mensajes" + Util.getSEPARADOR() + this.doc;
                m.marshal((Object)docOut, new FileOutputStream(xml));
            }
        }
        catch (Exception e) {
            if (!this.valid) {
                Start.pe("\t=> [" + this.doc + "]: TIF con Estructura Invalida.-");
                if (e.toString().indexOf(".Abort") != -1) {
                    String msgError = e.toString().substring(e.toString().indexOf(".Abort") + 19, e.toString().length() - 1);
                    Start.pe("\t+ " + msgError);
                } else {
                    Start.pe("\t+ " + e.toString());
                }
                Start.pe("\t=> Moviendo documento [" + this.doc + "] a [SMS_Home\\xml\\invalidos].-\n\n");
            }
            Start.pe("\t=> [" + this.doc + "]: Error manipulando archivo. Posiblemente no tiene permisos necesarios.-\n\n");
            this.valid = false;
        }
    }

    private void setRootTIF(documentWrapper docIn, Documento docOut) {
        try {
            if (docIn.getDocType().equals("TIF")) {
                docOut.setTipo(docIn.getDocType());
            }
            if (docIn.getVersion().equals("1.0")) {
                docOut.setVersion(docIn.getVersion());
            }
            if (docIn.existAttribute("tipo-accion") && !docIn.getAttribute("tipo-accion").equals("")) {
                docOut.setTipoAccion(docIn.getAttribute("tipo-accion").trim());
            }
            if (docIn.existAttribute("numero-referencia") && !docIn.getAttribute("numero-referencia").equals("")) {
                docOut.setNumeroReferencia(docIn.getAttribute("numero-referencia").trim());
            }
            if (docIn.existAttribute("numero-referencia-original") && !docIn.getAttribute("numero-referencia-original").equals("")) {
                docOut.setNumeroReferencia(docIn.getAttribute("numero-referencia-original").trim());
            }
            if (docIn.existAttribute("fecha-emision") && !docIn.getAttribute("fecha-emision").equals("")) {
                docOut.setFechaEmision(docIn.getAttribute("fecha-emision").trim());
            }
            if (docIn.existAttribute("sentido-operacion") && !docIn.getAttribute("sentido-operacion").equals("")) {
                docOut.setSentidoOperacion(docIn.getAttribute("sentido-operacion").trim());
            }
            if (docIn.existAttribute("transito") && !docIn.getAttribute("transito").equals("")) {
                docOut.setTransito(docIn.getAttribute("transito").trim());
            }
            if (docIn.existAttribute("condicion-carga") && !docIn.getAttribute("condicion-carga").equals("")) {
                docOut.setCondicionCarga(docIn.getAttribute("condicion-carga").trim());
            }
            if (docIn.existAttribute("nro-vagon") && !docIn.getAttribute("nro-vagon").equals("")) {
                docOut.setNroVagon(docIn.getAttribute("nro-vagon").trim());
            }
            if (docIn.existAttribute("tipo-vagon") && !docIn.getAttribute("tipo-vagon").equals("")) {
                docOut.setTipoVagon(docIn.getAttribute("tipo-vagon").trim());
            }
            if (docIn.existAttribute("origen-vagon") && !docIn.getAttribute("origen-vagon").equals("")) {
                docOut.setOrigenVagon(docIn.getAttribute("origen-vagon").trim());
            }
            if (docIn.existAttribute("peso-tara-vagon") && !docIn.getAttribute("peso-tara-vagon").equals("")) {
                docOut.setPesoTaraVagon(docIn.getAttribute("peso-tara-vagon").trim());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setParticipantesTIF(documentWrapper docIn, Documento docOut) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (docIn.existContainer("Participaciones")) {
                DocumentoType.ParticipacionesType participaciones = objFactory.createDocumentoTypeParticipacionesType();
                AttrContainer atc = docIn.getContainer("Participaciones");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.ParticipacionesType.ParticipacionType participacion = objFactory.createDocumentoTypeParticipacionesTypeParticipacionType();
                    if (prop.containsKey("nombre") && !prop.get("nombre").equals("")) {
                        participacion.setNombre(String.valueOf(prop.get("nombre")).trim());
                    }
                    if (prop.containsKey("valor-id") && !prop.get("valor-id").equals("")) {
                        participacion.setValorId(String.valueOf(prop.get("valor-id")).trim());
                    }
                    if (prop.containsKey("tipo-id") && !prop.get("tipo-id").equals("")) {
                        participacion.setTipoId(String.valueOf(prop.get("tipo-id")).trim());
                    }
                    if (prop.containsKey("nacion-id") && !prop.get("nacion-id").equals("")) {
                        participacion.setNacionId(String.valueOf(prop.get("nacion-id")).trim());
                    }
                    if (prop.containsKey("nombres") && !prop.get("nombres").equals("")) {
                        participacion.setNombres(String.valueOf(prop.get("nombres")).trim());
                    }
                    if (prop.containsKey("direccion") && !prop.get("direccion").equals("")) {
                        participacion.setDireccion(String.valueOf(prop.get("direccion")).trim());
                    }
                    if (prop.containsKey("codigo-pais") && !prop.get("codigo-pais").equals("")) {
                        participacion.setCodigoPais(String.valueOf(prop.get("codigo-pais")).trim());
                    }
                    participaciones.getParticipacion().add(participacion);
                }
                docOut.setParticipaciones(participaciones);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setRootCPF(documentWrapper docIn, Documento docOut) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (docIn.existContainer("Cpfs")) {
                DocumentoType.CpfsType cpfs = objFactory.createDocumentoTypeCpfsType();
                AttrContainer atc = docIn.getContainer("Cpfs");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.CpfsType.CpfType cpf = objFactory.createDocumentoTypeCpfsTypeCpfType();
                    if (prop.containsKey("numero-referencia") && !prop.get("numero-referencia").equals("")) {
                        cpf.setNumeroReferencia(String.valueOf(prop.get("numero-referencia")).trim());
                    }
                    if (prop.containsKey("moneda") && !prop.get("moneda").equals("")) {
                        cpf.setMoneda(String.valueOf(prop.get("moneda")).trim());
                    }
                    if (prop.containsKey("valor-fot") && !prop.get("valor-fot").equals("")) {
                        cpf.setValorFot(String.valueOf(prop.get("valor-fot")).trim());
                    }
                    if (prop.containsKey("total-peso") && !prop.get("total-peso").equals("")) {
                        cpf.setTotalPeso(String.valueOf(prop.get("total-peso")).trim());
                    }
                    if (prop.containsKey("total-bultos") && !prop.get("total-bultos").equals("")) {
                        cpf.setTotalBultos(String.valueOf(prop.get("total-bultos")).trim());
                    }
                    this.setParticipantesCPF(ci, cpf);
                    this.setLocacionesCPF(ci, cpf);
                    this.setItemsCPF(ci, cpf);
                    this.setPrecintosCPF(ci, cpf);
                    this.setItinerariosCPF(ci, cpf);
                    this.setDocAnexosCPF(ci, cpf);
                    this.setFletesCPF(ci, cpf);
                    this.setObservacionesCPF(ci, cpf);
                    cpfs.getCpf().add(cpf);
                }
                docOut.setCpfs(cpfs);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setParticipantesCPF(ContainerItem contItem, DocumentoType.CpfsType.CpfType cpf) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (contItem.existContainer("Participaciones")) {
                DocumentoType.CpfsType.CpfType.ParticipacionesType participaciones = objFactory.createDocumentoTypeCpfsTypeCpfTypeParticipacionesType();
                AttrContainer atc = contItem.getContainer("Participaciones");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.CpfsType.CpfType.ParticipacionesType.ParticipacionType participacion = objFactory.createDocumentoTypeCpfsTypeCpfTypeParticipacionesTypeParticipacionType();
                    if (prop.containsKey("nombre") && !prop.get("nombre").equals("")) {
                        participacion.setNombre(String.valueOf(prop.get("nombre")).trim());
                    }
                    if (prop.containsKey("valor-id") && !prop.get("valor-id").equals("")) {
                        participacion.setValorId(String.valueOf(prop.get("valor-id")).trim());
                    }
                    if (prop.containsKey("tipo-id") && !prop.get("tipo-id").equals("")) {
                        participacion.setTipoId(String.valueOf(prop.get("tipo-id")).trim());
                    }
                    if (prop.containsKey("nacion-id") && !prop.get("nacion-id").equals("")) {
                        participacion.setNacionId(String.valueOf(prop.get("nacion-id")).trim());
                    }
                    if (prop.containsKey("nombres") && !prop.get("nombres").equals("")) {
                        participacion.setNombres(String.valueOf(prop.get("nombres")).trim());
                    }
                    if (prop.containsKey("direccion") && !prop.get("direccion").equals("")) {
                        participacion.setDireccion(String.valueOf(prop.get("direccion")).trim());
                    }
                    if (prop.containsKey("codigo-pais") && !prop.get("codigo-pais").equals("")) {
                        participacion.setCodigoPais(String.valueOf(prop.get("codigo-pais")).trim());
                    }
                    participaciones.getParticipacion().add(participacion);
                }
                cpf.setParticipaciones(participaciones);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setLocacionesCPF(ContainerItem contItem, DocumentoType.CpfsType.CpfType cpf) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (contItem.existContainer("Locaciones")) {
                DocumentoType.CpfsType.CpfType.LocacionesType locaciones = objFactory.createDocumentoTypeCpfsTypeCpfTypeLocacionesType();
                AttrContainer atc = contItem.getContainer("Locaciones");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.CpfsType.CpfType.LocacionesType.LocacionType locacion = objFactory.createDocumentoTypeCpfsTypeCpfTypeLocacionesTypeLocacionType();
                    if (prop.containsKey("nombre") && !prop.get("nombre").equals("")) {
                        locacion.setNombre(String.valueOf(prop.get("nombre")).trim());
                    }
                    if (prop.containsKey("codigo") && !prop.get("codigo").equals("")) {
                        locacion.setCodigo(String.valueOf(prop.get("codigo")).trim());
                    }
                    if (prop.containsKey("descripcion") && !prop.get("descripcion").equals("")) {
                        locacion.setDescripcion(String.valueOf(prop.get("descripcion")).trim());
                    }
                    locaciones.getLocacion().add(locacion);
                }
                cpf.setLocaciones(locaciones);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setItemsCPF(ContainerItem contItem, DocumentoType.CpfsType.CpfType cpf) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (contItem.existContainer("Items")) {
                DocumentoType.CpfsType.CpfType.ItemsType items = objFactory.createDocumentoTypeCpfsTypeCpfTypeItemsType();
                AttrContainer atc = contItem.getContainer("Items");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.CpfsType.CpfType.ItemsType.ItemType item = objFactory.createDocumentoTypeCpfsTypeCpfTypeItemsTypeItemType();
                    if (prop.containsKey("numero-item") && !prop.get("numero-item").equals("")) {
                        item.setNumeroItem(String.valueOf(prop.get("numero-item")).trim());
                    }
                    if (prop.containsKey("marcas") && !prop.get("marcas").equals("")) {
                        item.setMarcas(String.valueOf(prop.get("marcas")).trim());
                    }
                    if (prop.containsKey("codigo-tipo-bulto") && !prop.get("codigo-tipo-bulto").equals("")) {
                        item.setCodigoTipoBulto(String.valueOf(prop.get("codigo-tipo-bulto")).trim());
                    }
                    if (prop.containsKey("desc-mercancia") && !prop.get("desc-mercancia").equals("")) {
                        item.setDescMercancia(String.valueOf(prop.get("desc-mercancia")).trim());
                    }
                    if (prop.containsKey("obs-item") && !prop.get("obs-item").equals("")) {
                        item.setObsItem(String.valueOf(prop.get("obs-item")).trim());
                    }
                    if (prop.containsKey("origen-mercancia") && !prop.get("origen-mercancia").equals("")) {
                        item.setOrigenMercancia(String.valueOf(prop.get("origen-mercancia")).trim());
                    }
                    if (prop.containsKey("cantidad-bulto") && !prop.get("cantidad-bulto").equals("")) {
                        item.setCantidadBulto(String.valueOf(prop.get("cantidad-bulto")).trim());
                    }
                    if (prop.containsKey("peso-bruto") && !prop.get("peso-bruto").equals("")) {
                        item.setPesoBruto(String.valueOf(prop.get("peso-bruto")).trim());
                    }
                    if (prop.containsKey("valor-dolar") && !prop.get("valor-dolar").equals("")) {
                        item.setValorDolar(String.valueOf(prop.get("valor-dolar")).trim());
                    }
                    if (prop.containsKey("cod-naladi") && !prop.get("cod-naladi").equals("")) {
                        item.setCodNaladi(String.valueOf(prop.get("cod-naladi")).trim());
                    }
                    items.getItem().add(item);
                }
                cpf.setItems(items);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setPrecintosCPF(ContainerItem contItem, DocumentoType.CpfsType.CpfType cpf) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (contItem.existContainer("Precintos")) {
                DocumentoType.CpfsType.CpfType.PrecintosType precintos = objFactory.createDocumentoTypeCpfsTypeCpfTypePrecintosType();
                AttrContainer atc = contItem.getContainer("Precintos");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.CpfsType.CpfType.PrecintosType.PrecintoType precinto = objFactory.createDocumentoTypeCpfsTypeCpfTypePrecintosTypePrecintoType();
                    if (prop.containsKey("tipo") && !prop.get("tipo").equals("")) {
                        precinto.setTipo(String.valueOf(prop.get("tipo")).trim());
                    }
                    if (prop.containsKey("numero") && !prop.get("numero").equals("")) {
                        precinto.setNumero(String.valueOf(prop.get("numero")).trim());
                    }
                    precintos.getPrecinto().add(precinto);
                }
                cpf.setPrecintos(precintos);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setItinerariosCPF(ContainerItem contItem, DocumentoType.CpfsType.CpfType cpf) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (contItem.existContainer("Itinerarios")) {
                DocumentoType.CpfsType.CpfType.ItinerariosType itinerarios = objFactory.createDocumentoTypeCpfsTypeCpfTypeItinerariosType();
                AttrContainer atc = contItem.getContainer("Itinerarios");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.CpfsType.CpfType.ItinerariosType.ItinerarioType itinerario = objFactory.createDocumentoTypeCpfsTypeCpfTypeItinerariosTypeItinerarioType();
                    if (prop.containsKey("secuencia") && !prop.get("secuencia").equals("")) {
                        itinerario.setSecuencia(String.valueOf(prop.get("secuencia")).trim());
                    }
                    if (prop.containsKey("lugar") && !prop.get("lugar").equals("")) {
                        itinerario.setLugar(String.valueOf(prop.get("lugar")).trim());
                    }
                    if (prop.containsKey("nombre") && !prop.get("nombre").equals("")) {
                        itinerario.setNombre(String.valueOf(prop.get("nombre")).trim());
                    }
                    if (prop.containsKey("descripcion") && !prop.get("descripcion").equals("")) {
                        itinerario.setDescripcion(String.valueOf(prop.get("descripcion")).trim());
                    }
                    itinerarios.getItinerario().add(itinerario);
                }
                cpf.setItinerarios(itinerarios);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setDocAnexosCPF(ContainerItem contItem, DocumentoType.CpfsType.CpfType cpf) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (contItem.existContainer("DocumentosAnexos")) {
                DocumentoType.CpfsType.CpfType.DocumentosAnexosType docsAnexos = objFactory.createDocumentoTypeCpfsTypeCpfTypeDocumentosAnexosType();
                AttrContainer atc = contItem.getContainer("DocumentosAnexos");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.CpfsType.CpfType.DocumentosAnexosType.DocumentoanexoType docAnexo = objFactory.createDocumentoTypeCpfsTypeCpfTypeDocumentosAnexosTypeDocumentoanexoType();
                    if (prop.containsKey("tipo") && !prop.get("tipo").equals("")) {
                        docAnexo.setTipo(String.valueOf(prop.get("tipo")).trim());
                    }
                    if (prop.containsKey("numero") && !prop.get("numero").equals("")) {
                        docAnexo.setNumero(String.valueOf(prop.get("numero")).trim());
                    }
                    if (prop.containsKey("fecha") && !prop.get("fecha").equals("")) {
                        docAnexo.setFecha(String.valueOf(prop.get("fecha")).trim());
                    }
                    if (prop.containsKey("descripcion") && !prop.get("descripcion").equals("")) {
                        docAnexo.setDescripcion(String.valueOf(prop.get("descripcion")).trim());
                    }
                    docsAnexos.getDocumentoanexo().add(docAnexo);
                }
                cpf.setDocumentosAnexos(docsAnexos);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setFletesCPF(ContainerItem contItem, DocumentoType.CpfsType.CpfType cpf) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (contItem.existContainer("Fletes")) {
                DocumentoType.CpfsType.CpfType.FletesType fletes = objFactory.createDocumentoTypeCpfsTypeCpfTypeFletesType();
                AttrContainer atc = contItem.getContainer("Fletes");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.CpfsType.CpfType.FletesType.FleteType flete = objFactory.createDocumentoTypeCpfsTypeCpfTypeFletesTypeFleteType();
                    if (prop.containsKey("sector") && !prop.get("sector").equals("")) {
                        flete.setSector(String.valueOf(prop.get("sector")).trim());
                    }
                    if (prop.containsKey("monto") && !prop.get("monto").equals("")) {
                        flete.setMonto(String.valueOf(prop.get("monto")).trim());
                    }
                    fletes.getFlete().add(flete);
                }
                cpf.setFletes(fletes);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setObservacionesCPF(ContainerItem contItem, DocumentoType.CpfsType.CpfType cpf) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (contItem.existContainer("Observaciones")) {
                DocumentoType.CpfsType.CpfType.ObservacionesType observaciones = objFactory.createDocumentoTypeCpfsTypeCpfTypeObservacionesType();
                AttrContainer atc = contItem.getContainer("Observaciones");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.CpfsType.CpfType.ObservacionesType.ObservacionType observacion = objFactory.createDocumentoTypeCpfsTypeCpfTypeObservacionesTypeObservacionType();
                    if (prop.containsKey("nombre") && !prop.get("nombre").equals("")) {
                        observacion.setNombre(String.valueOf(prop.get("nombre")).trim());
                    }
                    if (prop.containsKey("contenido") && !prop.get("contenido").equals("")) {
                        observacion.setContenido(String.valueOf(prop.get("contenido")).trim());
                    }
                    observaciones.getObservacion().add(observacion);
                }
                cpf.setObservaciones(observaciones);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isValid() {
        return this.valid;
    }
}

